/*
   This program starts a child process and wants to redirect
   the child's stdin to a file and redirect the child's stdout
   to a file. But this cannot be done in Java 6 (or earlier).
   So we fake it (in a really dumb way).

   In this program, the parent reads all of the data from the
   input file and writes that data to the child's stdin. After
   this stage of the program is done, the parent goes to the
   "other end" of the child process and reads all of the data
   from the child's stdout and writes that data to the output
   file.


   Important: Notice that this program is logically the
   same as the following command line.

   C:\> java Double < L50.txt > result.txt

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection before
   running the program Double.class. In the case of this
   program, the program itself does the I/O redirection
   for its child.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_RedirectChildStdinStdoutToFiles_ver1
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the child.
      String cmd = "java Double";
      // Execute the filter.
      Process process = Runtime.getRuntime().exec(cmd);

      // Create a stream that writes data to the child's stdin stream.
      PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );
      // Create a stream that reads data from the child's stdout stream.
      Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Create a stream that reads data from the input file.
      Scanner inputFile = new Scanner( new FileInputStream( "L50.txt" ) );
      // Create a stream that writes data to the output file.
      PrintStream outputFile =  new PrintStream( new FileOutputStream( "result.txt" ) );


      // Read all of the data out of the  input file
      // and send it to the child's stdin.
      while ( inputFile.hasNextLine() )
      {
         String oneLine = inputFile.nextLine();
         stdinOfChild.println( oneLine );
      }
      stdinOfChild.close(); //THIS IS IMPORTANT (otherwise, the child will just hang)


      // Now read all of the data out of the child's stdout
      // and send it to the output file.
      while ( stdoutOfChild.hasNextLine() )
      {
         String oneLine = stdoutOfChild.nextLine();
         outputFile.println( oneLine );
      }

      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
      outputFile.close();
   }
}

/*
   IMPORTANT:
   Change the input file to L200.txt, recompile, and run the
   program again. The program will hang. Why?

   Notice that this program reads the whole input file and sends
   it to the child. After the whole file has been sent to the child,
   this program starts to read from the child's stdout stream. But
   while this program was sending data to the child's stdin stream,
   the child was processing the data and writing the results to its
   stdout stream. This data just piles up in an output buffer associated
   to the child's stdout stream. This buffer can fill up, and the file
   L200.txt is large enough to do this. When the buffer fills up, the
   child's writes to stdout block! When the child blocks on a write to
   stdout, it no longer reads from stdin. But now the parent can fill
   up the buffer associated with the child's stdin stream. When that
   buffer fills up, the parent block on its writes! But when the parent
   blocks, it cannot go and read from the child's stdout buffer. So the
   parent and child both stay blocked forever (deadlocked)!
*/